
from gurobipy import *

# Create a new model
m = Model("Fishing_Optimization")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Pacific_Days")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Atlantic_Days")

# Define the objective function
m.setObjective(5000*x + 7000*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 4*y >= 18, name="Fish_Requirement")
m.addConstr(2*x + 3*y >= 10, name="Crab_Requirement")
m.addConstr(0.5*x + y >= 5, name="Lobster_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Days in Pacific: {x.x}")
    print(f"Days in Atlantic: {y.x}")
    print(f"Total Cost: ${5000*x.x + 7000*y.x}")
else:
    print("No optimal solution found.")
