
import gurobi

def fishing_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="Pacific_days", lb=0)  # Days in Pacific ocean
    y = model.addVar(name="Atlantic_days", lb=0)  # Days in Atlantic ocean

    # Objective function: Minimize cost
    model.setObjective(5000*x + 7000*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x + 4*y >= 18, name="Fish_demand")  # Fish demand
    model.addConstr(2*x + 3*y >= 10, name="Crab_demand")  # Crab demand
    model.addConstr(0.5*x + y >= 5, name="Lobster_demand")  # Lobster demand

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Days in Pacific ocean: {x.varValue}")
        print(f"Days in Atlantic ocean: {y.varValue}")
        print(f"Total Cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    fishing_problem()
