
import gurobipy as gp

# Create a new model
m = gp.Model("food_truck")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="fries")
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="onion_rings")

# Set objective function
m.setObjective(4 * x + 5 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 20, "min_fries")
m.addConstr(x <= 50, "max_fries")
m.addConstr(y >= 10, "min_onion_rings")
m.addConstr(y <= 40, "max_onion_rings")
m.addConstr(x + y <= 50, "total_orders")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Fries orders: {x.x}")
    print(f"Onion rings orders: {y.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

