
from gurobipy import *

# Create a new model
m = Model("Food Truck Profit Maximization")

# Define the decision variables
F = m.addVar(name="fries", lb=20, ub=50)  # Number of orders of fries
R = m.addVar(name="onion_rings", lb=10, ub=40)  # Number of orders of onion rings

# Define the objective function: Maximize profit
m.setObjective(4*F + 5*R, GRB.MAXIMIZE)

# Add constraints
m.addConstr(F + R <= 50, name="total_orders")  # Total orders cannot exceed 50

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Orders of fries: {F.x}")
    print(f"Orders of onion rings: {R.x}")
    print(f"Maximum profit: ${4*F.x + 5*R.x:.2f}")
else:
    print("No optimal solution found")
