
import gurobi

def solve_food_truck_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables with their bounds
    x = model.addVar(lb=20, ub=50, name="fries")
    y = model.addVar(lb=10, ub=40, name="onion_rings")

    # Objective function: Maximize profit
    model.setObjective(4*x + 5*y, gurobi.GRB.MAXIMIZE)

    # Constraint: Total orders cannot exceed 50
    model.addConstr(x + y <= 50, name="total_orders")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum Profit: ${4*x.varValue + 5*y.varValue}")
    else:
        print("The model is infeasible.")

solve_food_truck_problem()
