
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("advertising_optimization")

# Create variables
x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="grocery_ads")
x2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="train_ads")
x3 = model.addVar(lb=0, vtype=GRB.INTEGER, name="waterpark_ads")

# Set objective function
model.setObjective(10000*x1 + 20000*x2 + 50000*x3, GRB.MAXIMIZE)

# Add constraints
model.addConstr(300*x1 + 500*x2 + 1000*x3 <= 50000, "budget")
model.addConstr(x2 <= 15, "train_limit")
model.addConstr(x3 <= (x1 + x2 + x3)/3, "waterpark_proportion")
model.addConstr(x1 >= 0.1*(x1 + x2 + x3), "grocery_minimum")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Viewership: {model.objVal}")
    print(f"Grocery Store Ads: {x1.x}")
    print(f"Train Station Ads: {x2.x}")
    print(f"Water Park Ads: {x3.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

