
import gurobipy as gp

# Create a new model
m = gp.Model("Iota_Food_Advertising")

# Decision variables
G = m.addVar(name="Grocery", lb=0, vtype=gp.GRB.INTEGER)  # Ads in grocery stores
T = m.addVar(name="Train", lb=0, vtype=gp.GRB.INTEGER)  # Ads in train stations
W = m.addVar(name="Water_Park", lb=0, vtype=gp.GRB.INTEGER)  # Ads in water parks

# Objective: Maximize viewership
m.setObjective(10000*G + 20000*T + 50000*W, gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(300*G + 500*T + 1000*W <= 50000, name="Budget")

# Train station ad limit
m.addConstr(T <= 15, name="Train_Limit")

# Water park ad limit
m.addConstr(2*W <= G + T, name="Water_Park_Limit")

# Grocery store ad minimum
m.addConstr(9*G >= T + W, name="Grocery_Min")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Ads in Grocery Stores: {G.varValue}")
    print(f"Ads in Train Stations: {T.varValue}")
    print(f"Ads in Water Parks: {W.varValue}")
    print(f"Max Viewership: {m.objVal}")
else:
    print("The model is infeasible.")
