
from gurobipy import *

# Create a new model
m = Model("Art Gallery Optimization")

# Decision variables
P = m.addVar(vtype=GRB.INTEGER, name="Paintings")
Ph = m.addVar(vtype=GRB.INTEGER, name="PhotoPrints")

# Objective function: Maximize profit
m.setObjective(330*P + 170*Ph, GRB.MAXIMIZE)

# Constraints
# Wall space constraint
m.addConstr(7*P + 4*Ph <= 200, "WallSpace")
# Budget constraint
m.addConstr(400*P + 200*Ph <= 7000, "Budget")
# At least 20% of items are photo prints
m.addConstr(0.80*Ph >= 0.20*P, "PhotoPrintPercentage")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Paintings: {P.x}")
    print(f"Number of Photo Prints: {Ph.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
