
import gurobi

def solve_gallery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    P = model.addVar(name="paintings", vtype=gurobi.GRB.INTEGER)
    PH = model.addVar(name="photo_prints", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(330 * P + 170 * PH, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * P + 4 * PH <= 200, name="wall_space")
    model.addConstr(400 * P + 200 * PH <= 7000, name="budget")
    model.addConstr(P - 4 * PH <= 0, name="photo_prints_percentage")

    # Non-negativity constraints are inherently handled by defining variables without bounds

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Number of paintings: {P.varValue}")
        print(f"Number of photo prints: {PH.varValue}")
        print(f"Max Profit: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_gallery_problem()
