
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment Optimization")

# Create decision variables
x = m.addVar(lb=0, name="rapper_investment")
y = m.addVar(lb=0, name="pop_artist_investment")

# Set objective function
m.setObjective(0.05 * x + 0.03 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 400000, "total_investment")
m.addConstr(y >= 3 * x, "investment_ratio")
m.addConstr(y <= 250000, "pop_artist_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in rapper: ${x.x}")
    print(f"Optimal investment in pop artist: ${y.x}")
    print(f"Maximum earnings: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

