
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define variables
R = m.addVar(lb=0, name="Investment_in_Rapper")
P = m.addVar(lb=0, name="Investment_in_Pop_Artist")

# Define constraints
m.addConstr(R + P == 400000, name="Total_Investment")
m.addConstr(P >= 3 * R, name="Pop_vs_Rapper_Investment")
m.addConstr(P <= 250000, name="Max_Pop_Investment")

# Define the objective function
m.setObjective(0.05 * R + 0.03 * P, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f" Invest in Rapper: ${R.x}")
    print(f" Invest in Pop Artist: ${P.x}")
    print(f" Total Earnings: ${0.05 * R.x + 0.03 * P.x}")
else:
    print("No optimal solution found")
