
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="rapper_investment")  # Investment in rapper
    y = model.addVar(lb=0, name="pop_artist_investment")  # Investment in pop artist

    # Objective function: Maximize earnings
    model.setObjective(0.05 * x + 0.03 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 400000, name="total_investment_constraint")
    model.addConstr(y >= 3 * x, name="pop_artist_min_investment_constraint")
    model.addConstr(y <= 250000, name="pop_artist_max_investment_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in rapper: ${x.varValue:.2f}")
        print(f"Optimal investment in pop artist: ${y.varValue:.2f}")
        print(f"Total earnings: ${0.05 * x.varValue + 0.03 * y.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
