
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(lb=0, name="lettuce_acres")  # Acres of lettuce
y = m.addVar(lb=0, name="spinach_acres") # Acres of spinach

# Set objective function
m.setObjective(50*x + 55*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50, "land_constraint")
m.addConstr(10*x + 12*y <= 5000, "watering_constraint")
m.addConstr(2*x + y <= 300, "picking_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Lettuce Acres: {x.x}")
    print(f"Spinach Acres: {y.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

