
import gurobi

def solve_farmers_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(lb=0, name="Lettuce_Acres")
    S = model.addVar(lb=0, name="Spinach_Acres")

    # Objective function: Maximize profit
    model.setObjective(50*L + 55*S, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(L + S <= 50, name="Land_Constraint")

    # Watering costs constraint
    model.addConstr(10*L + 12*S <= 5000, name="Watering_Costs_Constraint")

    # Picking time constraint
    model.addConstr(2*L + S <= 300, name="Picking_Time_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres for Lettuce: {L.varValue}")
        print(f"Optimal acres for Spinach: {S.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_farmers_problem()
