
import gurobipy as gp

# Create a new model
m = gp.Model("Museum_Gift_Shop")

# Create decision variables
x1 = m.addVar(nonneg=True, name="Package_1")
x2 = m.addVar(nonneg=True, name="Package_2")

# Set objective function
m.setObjective(10*x1 + 12*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 <= 1000, "Souvenir_Constraint")
m.addConstr(10*x1 + 15*x2 <= 1400, "Snack_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of Package 1 to sell: {x1.x:.0f}")
    print(f"Number of Package 2 to sell: {x2.x:.0f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

