
from gurobipy import *

# Create a model
m = Model("Museum_Gift_Shop")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="Package1")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="Package2")

# Set the objective function: Maximize profit
m.setObjective(10*x + 12*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 4*y <= 1000, "SouvenirConstraint")
m.addConstr(10*x + 15*y <= 1400, "SnackConstraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Package 1: {x.x}")
    print(f"Number of Package 2: {y.x}")
    print(f"Maximum Profit: ${10*x.x + 12*y.x}")
else:
    print("No optimal solution found")
