
import gurobi

def museum_gift_shop_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="Package_1")
    x2 = model.addVar(lb=0, name="Package_2")

    # Objective function: Maximize profit
    model.setObjective(10*x1 + 12*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 4*x2 <= 1000, name="souvenir_constraint")
    model.addConstr(10*x1 + 15*x2 <= 1400, name="snack_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Package 1 = {x1.varValue}, Package 2 = {x2.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the optimization
museum_gift_shop_optimization()
