
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Maximus_Ltd_Advertising")

# Variables
B = model.addVar(lb=0, ub=3, vtype=GRB.INTEGER, name="Billboards")
P = model.addVar(lb=0, vtype=GRB.INTEGER, name="Podcasts")
M = model.addVar(lb=0, vtype=GRB.INTEGER, name="Merchandises")

# Objective function: Maximize viewership
model.setObjective(40000*B + 10000*P + 2000*M, GRB.MAXIMIZE)

# Constraints
model.addConstr(B <= 3, name="Billboard_Limit")
model.addConstr(M <= 0.4*(B + P + M), name="Merchandise_Limit")
model.addConstr(P >= 0.25*(B + P + M), name="Podcast_Minimum")
model.addConstr(750*B + 1000*P + 300*M <= 20000, name="Budget_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Billboards: {B.varValue}")
    print(f"Podcasts: {P.varValue}")
    print(f"Merchandises: {M.varValue}")
    print(f"Max Viewership: {model.objVal}")
else:
    print("No optimal solution found")
