
import gurobipy as gp

# Create a new model
m = gp.Model("furniture_production")

# Create decision variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bedside_tables")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bookcases")

# Set objective function
m.setObjective(200*x + 500*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x + 5*y <= 30, "crafting_constraint")
m.addConstr(1.5*x + 3*y <= 20, "polishing_constraint")
m.addConstr(x >= 0, "x_nonnegativity")
m.addConstr(y >= 0, "y_nonnegativity")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal production plan:")
    print(f"Bedside tables: {x.x}")
    print(f"Bookcases: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

