
from gurobipy import *

# Create a model
m = Model("Furniture_Factory")

# Define variables
x1 = m.addVar(name='bedside_tables', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='bookcases', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(200*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x1 + 5*x2 <= 30, name='crafting_hours')
m.addConstr(1.5*x1 + 3*x2 <= 20, name='polishing_hours')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bedside tables: {x1.x}")
    print(f"Bookcases: {x2.x}")
    print(f"Maximum profit: ${200*x1.x + 500*x2.x:.2f}")
else:
    print("No optimal solution found")
