
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_BT = model.addVar(lb=0, name="Bedside_Tables")  # Number of bedside tables
    x_BC = model.addVar(lb=0, name="Bookcases")     # Number of bookcases

    # Objective function: Maximize profit
    model.setObjective(200 * x_BT + 500 * x_BC, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2.5 * x_BT + 5 * x_BC <= 30, name="Crafting_Hours")     # Crafting hours constraint
    model.addConstr(1.5 * x_BT + 3 * x_BC <= 20, name="Polishing_Hours")   # Polishing hours constraint

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels:")
        print(f"Bedside Tables: {x_BT.varValue}")
        print(f"Bookcases: {x_BC.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_production_problem()
