
import gurobipy as gp

# Create a new model
model = gp.Model("BagelSeasoningMix")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ordinary_bags")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="special_bags")

# Set objective function
model.setObjective(10*x + 12*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5*x + 10*y >= 50, "sesame_seeds")
model.addConstr(8*x + 6*y >= 60, "onion_powder")
model.addConstr(7*x + 8*y >= 65, "garlic_powder")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${model.objVal}")
    print(f"Number of ordinary bags: {x.x}")
    print(f"Number of special bags: {y.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

