
from gurobipy import *

# Create a model
m = Model("Bagel_Mix")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="ordinary_bags")
y = m.addVar(vtype=GRB.CONTINUOUS, name="special_bags")

# Define constraints
m.addConstr(5*x + 10*y >= 50, "sesame_seeds")
m.addConstr(8*x + 6*y >= 60, "onion_powder")
m.addConstr(7*x + 8*y >= 65, "garlic_powder")

# Define objective function
m.setObjective(10*x + 12*y, GRB.MINIMIZE)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ordinary bags: {x.x}")
    print(f"Special bags: {y.x}")
    print(f"Total cost: ${10*x.x + 12*y.x:.2f}")
else:
    print("No optimal solution found")
