
import gurobi

def solve_bagel_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="ordinary_bags", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="special_bags", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(10*x + 12*y, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(5*x + 10*y >= 50, name="sesame_seeds")
    model.addConstr(8*x + 6*y >= 60, name="onion_powder")
    model.addConstr(7*x + 8*y >= 65, name="garlic_powder")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_bagel_mix_problem()
