
import gurobipy as gp

# Create a new model
m = gp.Model("weight_loss_program")

# Create variables
v = m.addVar(lb=0, name="vietnamese_plates")
k = m.addVar(lb=0, name="korean_plates")

# Set objective function
m.setObjective(12.5 * v + 16.5 * k, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * v + 10 * k >= 250, "protein_constraint")
m.addConstr(20 * v + 14 * k >= 45, "carb_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Vietnamese plates: {v.x:.2f}")
    print(f"Korean plates: {k.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

