
from gurobipy import *

# Create a model
m = Model("Weight_Loss_Program")

# Define variables
V = m.addVar(vtype=GRB.CONTINUOUS, name="Vietnamese_Food")
K = m.addVar(vtype=GRB.CONTINUOUS, name="Korean_Food")

# Set objective function
m.setObjective(12.5*V + 16.5*K, GRB.MINIMIZE)

# Add constraints
m.addConstr(15*V + 10*K >= 250, "Protein_Constraint")
m.addConstr(20*V + 14*K >= 45, "Carbs_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vietnamese Food Plates: {V.x}")
    print(f"Korean Food Plates: {K.x}")
    print(f"Total Cost: ${12.5*V.x + 16.5*K.x:.2f}")
else:
    print("No optimal solution found.")
