
import gurobi

def solve_min_cost_program():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define decision variables
    x_V = model.addVar(name="Vietnamese", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x_K = model.addVar(name="Korean", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define objective function
    model.setObjective(12.5 * x_V + 16.5 * x_K, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(15 * x_V + 10 * x_K >= 250, name="protein_requirement")
    model.addConstr(20 * x_V + 14 * x_K >= 45, name="carb_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Minimum cost: ${model.objVal:.2f}")
        print(f"Vietnamese food: {x_V.x:.2f} plates")
        print(f"Korean food: {x_K.x:.2f} plates")
    else:
        print("The model is infeasible.")

solve_min_cost_program()
