
import gurobipy as gp

# Create a new model
model = gp.Model("BallProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="soccer_balls")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="basketballs")

# Set objective function
model.setObjective(5*x + 8*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x + 15*y <= 5000, "sewing_time")
model.addConstr(10*x + 12*y <= 4500, "quality_checking_time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of soccer balls: {x.x}")
    print(f"Number of basketballs: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

