
from gurobipy import *

# Create a model
m = Model("Production_Optimization")

# Define decision variables
x = m.addVar(name="soccer_balls", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="basketballs", vtype=GRB.CONTINUOUS, lb=0)

# Objective function: Maximize profit
m.setObjective(5*x + 8*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*x + 15*y <= 5000, name="sewing_time")
m.addConstr(10*x + 12*y <= 4500, name="quality_checking")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x.x:.2f} soccer balls and {y.x:.2f} basketballs.")
else:
    print("No optimal solution found. The problem might be infeasible.")

