
import gurobipy as gp

# Create a new model
model = gp.Model("Soccer_Basket_Balls")

# Define the decision variables
x = model.addVar(name="Soccer_Balls", lb=0, vtype=gp.GRB.CONTINUOUS)
y = model.addVar(name="Basket_Balls", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(5 * x + 8 * y, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(20 * x + 15 * y <= 5000, name="Sewing_Time_Constraint")
model.addConstr(10 * x + 12 * y <= 4500, name="Quality_Checking_Time_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Soccer Balls = {x.varValue:.2f}, Basket Balls = {y.varValue:.2f}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
