
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("MathContest")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="long_answer")
y = m.addVar(vtype=GRB.INTEGER, name="multiple_choice")

# Set objective
m.setObjective(10*x + 2*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 15, "total_questions")
m.addConstr(x >= 5, "min_long_answer")
m.addConstr(y >= 7, "min_multiple_choice")
m.addConstr(x <= 11, "max_long_answer")
m.addConstr(y <= 11, "max_multiple_choice")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of long answer questions: {x.x}")
    print(f"Number of multiple choice questions: {y.x}")
    print(f"Maximum score: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

