
from gurobipy import *

# Create a model
m = Model("Math_Contest")

# Define decision variables
L = m.addVar(vtype=GRB.INTEGER, name="Long_Answer_Questions")
M = m.addVar(vtype=GRB.INTEGER, name="Multiple_Choice_Questions")

# Set the objective function
m.setObjective(10*L + 2*M, GRB.MAXIMIZE)

# Add constraints
m.addConstr(L + M <= 15, "Total_Time_Constraint")
m.addConstr(L >= 5, "Min_Long_Answer_Requirement")
m.addConstr(M >= 7, "Min_Multiple_Choice_Requirement")
m.addConstr(L <= 11, "Max_Long_Answer_Limit")
m.addConstr(M <= 11, "Max_Multiple_Choice_Limit")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution: {L.varName} = {int(L.x)} and {M.varName} = {int(M.x)}")
    print(f"Maximum Score: {m.objVal}")
else:
    print("The model is infeasible.")
