
import gurobi

def solve_problem():
    model = gurobi.Model()

    x = model.addVar(lb=5, ub=11, name="long_answer_questions")
    y = model.addVar(lb=7, ub=11, name="multiple_choice_questions")

    model.setObjective(10 * x + 2 * y, gurobi.GRB.MAXIMIZE)

    model.addConstr(x + y <= 15, name="total_questions")

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        long_answer_optimal = x.varValue
        multiple_choice_optimal = y.varValue
        max_score = 10 * long_answer_optimal + 2 * multiple_choice_optimal

        print(f"Optimal long answer questions: {long_answer_optimal}")
        print(f"Optimal multiple choice questions: {multiple_choice_optimal}")
        print(f"Maximum score: {max_score}")
    else:
        print("The problem is infeasible.")

solve_problem()
