
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Jewelry_Production")

# Create decision variables
b = model.addVar(lb=0, vtype=GRB.INTEGER, name="bracelets") # Integer bracelets
r = model.addVar(lb=0, vtype=GRB.INTEGER, name="rings") # Integer rings

# Set objective function
model.setObjective(700*b + 300*r, GRB.MAXIMIZE)

# Add constraints
model.addConstr(b <= 4, "bracelet_limit")
model.addConstr(r <= 7, "ring_limit")
model.addConstr(b + r <= 30, "jeweler_capacity")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of bracelets to produce: {b.x}")
    print(f"Number of rings to produce: {r.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

