
from gurobipy import *

# Create a model
m = Model("Jewelry_Profit")

# Define the decision variables
B = m.addVar(lb=0, ub=4, vtype=GRB.INTEGER, name="Bracelets")
R = m.addVar(lb=0, ub=7, vtype=GRB.INTEGER, name="Rings")

# Set the objective function to maximize profit
m.setObjective(700*B + 300*R, GRB.MAXIMIZE)

# Add constraints
m.addConstr(B <= 4, "Max_Bracelets")
m.addConstr(R <= 7, "Max_Rings")
m.addConstr(B + R <= 30, "Master_Jeweler_Checks")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {B.x} bracelets and {R.x} rings.")
    print(f"Maximum profit: ${700*B.x + 300*R.x}")
else:
    print("No optimal solution found.")

