
import gurobi

def jewelry_production_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, ub=4, name="Bracelets")
    R = model.addVar(lb=0, ub=7, name="Rings")

    # Objective function: Maximize profit
    model.setObjective(700*B + 300*R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(B <= 4, name="Bracelet_production_limit")
    model.addConstr(R <= 7, name="Ring_production_limit")
    model.addConstr(B + R <= 30, name="Master_jeweler_approval_limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Bracelets = {B.varValue}, Rings = {R.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the optimization
jewelry_production_optimization()
