
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Gardener_Optimization")

# Create variables
x = m.addVar(lb=0, name="sunflowers") # Square feet of sunflowers
y = m.addVar(lb=0, name="roses") # Square feet of roses

# Set objective function
m.setObjective(450*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "area")
m.addConstr(67*x + 52*y <= 6500, "budget")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} square feet of sunflowers")
    print(f"Plant {y.x:.2f} square feet of roses")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

