
from gurobipy import *

# Create a new model
m = Model("Gardener_Optimization")

# Define the decision variables
x = m.addVar(name="sunflowers", lb=0)  # Area for sunflowers
y = m.addVar(name="roses", lb=0)       # Area for roses

# Set the objective function: Maximize profit
m.setObjective(450*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(67*x + 52*y <= 6500, name="budget")  # Budget constraint
m.addConstr(x + y <= 100, name="space")          # Space constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Area for sunflowers: {x.x} square feet")
    print(f"Area for roses: {y.x} square feet")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")

