
import gurobi

def solve_gardener_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(lb=0, name="Sunflowers")
    R = model.addVar(lb=0, name="Roses")

    # Objective function: Maximize profit
    model.setObjective(450 * S + 100 * R, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(S + R <= 100, name="Area_Constraint")
    model.addConstr(67 * S + 52 * R <= 6500, name="Budget_Constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Sunflowers: {S.varValue}, Roses: {R.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_gardener_problem()
