
import gurobipy as gp

# Create a new model
model = gp.Model("smoothie_optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_smoothies")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vegetable_smoothies")

# Set objective function
model.setObjective(4*x + 5*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 7*y <= 400, "cutting_constraint")
model.addConstr(5*x + 4*y <= 400, "blending_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Fruit Smoothies (x): {x.x}")
    print(f"Vegetable Smoothies (y): {y.x}")
    print(f"Optimal Profit: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

