
from gurobipy import *

# Create a new model
m = Model("Smoothie_Optimization")

# Define the decision variables
F = m.addVar(vtype=GRB.INTEGER, name="Fruit_Smoothies")
V = m.addVar(vtype=GRB.INTEGER, name="Vegetable_Smoothies")

# Set the objective function (maximize profit)
m.setObjective(4*F + 5*V, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*F + 7*V <= 400, "Cutting_Machine_Time")
m.addConstr(5*F + 4*V <= 400, "Blending_Machine_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Fruit Smoothies: {F.x}")
    print(f"Number of Vegetable Smoothies: {V.x}")
    print(f"Maximum Profit: ${4*F.x + 5*V.x}")
else:
    print("No optimal solution found.")
