
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("CowFeed")

# Create variables
x = m.addVar(lb=0, name="enriched_hay") # Kilograms of enriched hay per cow
y = m.addVar(lb=0, name="chicken_scraps") # Kilograms of chicken scraps per cow

# Set objective function
m.setObjective(200*x + 350*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.3*x + 0.6*y >= 1.5, "protein_req")
m.addConstr(0.1*x + 0.2*y <= 0.5, "vitamin_limit")
m.addConstr(0.15*x + 0.05*y >= 0.5, "mineral_req")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost per cow per day: ${m.objVal:.2f}")
    print(f"Enriched hay per cow per day: {x.x:.2f} kg")
    print(f"Chicken scraps per cow per day: {y.x:.2f} kg")
    print(f"Total cost for 30 cows per day: ${m.objVal * 30:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

