
from gurobipy import *

# Create a new model
m = Model("Cow_Feeding")

# Define variables
x1 = m.addVar(lb=0, name="enriched_hay")  # Amount of enriched hay in kg
x2 = m.addVar(lb=0, name="chicken_scraps")  # Amount of chicken scraps in kg

# Objective function: Minimize total cost
m.setObjective(200*x1 + 350*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(0.3*x1 + 0.6*x2 >= 45, name="protein_requirement")
m.addConstr(0.15*x1 + 0.05*x2 >= 15, name="minerals_requirement")
m.addConstr(0.1*x1 + 0.2*x2 <= 15, name="vitamins_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Enriched Hay: {x1.x} kg")
    print(f"Chicken Scraps: {x2.x} kg")
    print(f"Total Cost: ${m.objVal}")
else:
    print("No optimal solution found")

