
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("cow_feeding")

# Decision variables
x = model.addVar(lb=0, name="enriched_hay")  # kg per cow
y = model.addVar(lb=0, name="chicken_scraps")  # kg per cow

# Objective: Minimize cost for one cow
model.setObjective(200*x + 350*y, GRB.MINIMIZE)

# Constraints
protein_requirement = model.addConstr(0.3*x + 0.6*y >= 1.5, name="protein")
vitamins_limit = model.addConstr(0.1*x + 0.2*y <= 0.5, name="vitamins")
minerals_requirement = model.addConstr(0.15*x + 0.05*y >= 0.5, name="minerals")

# Solve the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost per cow: ${model.objVal:.2f}")
    print(f"Enriched hay per cow: {x.varValue:.2f} kg")
    print(f"Chicken scraps per cow: {y.varValue:.2f} kg")
    print(f"Total cost for 30 cows: ${model.objVal * 30:.2f}")
else:
    print("No optimal solution found.")
