
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("sandwich_optimization")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="premium_sandwiches")
y = model.addVar(vtype=GRB.INTEGER, name="regular_sandwiches")

# Set objective function
model.setObjective(5*x + 1*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*x + 4*y <= 400, "prep_time")
model.addConstr(5*x + 1*y <= 100, "meat")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Premium Sandwiches: {x.x}")
    print(f"Regular Sandwiches: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

