
from gurobipy import *

# Create a new model
m = Model("Sandwich_Optimization")

# Define the decision variables
x_p = m.addVar(vtype=GRB.CONTINUOUS, name="premium_sandwiches", lb=0)
x_r = m.addVar(vtype=GRB.CONTINUOUS, name="regular_sandwiches", lb=0)

# Set the objective function: Maximize profit
m.setObjective(5*x_p + x_r, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x_p + 4*x_r <= 400, "preparation_time")
m.addConstr(5*x_p + x_r <= 100, "meat_availability")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium Sandwiches: {x_p.x}")
    print(f"Regular Sandwiches: {x_r.x}")
    print(f"Max Profit: ${5*x_p.x + x_r.x:.2f}")
else:
    print("No optimal solution found")

