
import gurobi as gp

# Create a new model
m = gp.Model("sandwich_problem")

# Define the decision variables
P = m.addVar(lb=0, name="premium_sandwiches")
R = m.addVar(lb=0, name="regular_sandwiches")

# Objective function: Maximize 5P + R
m.setObjective(5 * P + R, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(6 * P + 4 * R <= 400, name="preparation_time")
m.addConstr(5 * P + R <= 100, name="meat_slices")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Premium sandwiches: {P.varValue}")
    print(f"Regular sandwiches: {R.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
