
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("FragranceMixture")

# Create decision variables
x = model.addVar(lb=0, name="essential_oil")
y = model.addVar(lb=0, name="fruit_scent")

# Set objective function
model.setObjective(3.5 * x + 2 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * x + 10 * y >= 6, "min_aromatic_notes")
model.addConstr(3 * x + 10 * y <= 8, "max_aromatic_notes")
model.addConstr(9 * x + 4 * y >= 7, "min_duration")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found. Minimum Cost: ${model.objVal:.2f}")
    print(f"Essential Oil Units: {x.x:.2f}")
    print(f"Fruit Scent Units: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

