
import gurobi

def solve_perfume_mixture():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="essential_oil", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="fruit_scent", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize cost
    model.setObjective(3.50 * x + 2 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x + 10 * y >= 6, name="aromatic_notes_min")
    model.addConstr(3 * x + 10 * y <= 8, name="aromatic_notes_max")
    model.addConstr(9 * x + 4 * y >= 7, name="duration")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Essential Oil: {x.varValue}")
        print(f"Fruit Scent: {y.varValue}")
        print(f"Cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_perfume_mixture()
