
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("phone_production")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="regular_models")
y = m.addVar(vtype=GRB.CONTINUOUS, name="premium_models")

# Set objective function
m.setObjective(200*x + 500*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(70*x + 100*y <= 6000, "assembly_constraint")
m.addConstr(25*x + 30*y <= 4000, "software_constraint")
m.addConstr(x >= 0, "regular_nonnegativity")
m.addConstr(y >= 0, "premium_nonnegativity")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular models: {x.x}")
    print(f"Number of premium models: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

